/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2complements.content.item.wand;

import dev.xkmc.l2complements.content.item.wand.WandEffectToClient;
import dev.xkmc.l2complements.content.item.wand.WandItem;
import dev.xkmc.l2complements.init.data.LCConfig;
import dev.xkmc.l2complements.init.data.LangData;
import dev.xkmc.l2library.util.raytrace.RayTraceUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HellfireWand
extends WandItem {
    public static final int RANGE = 64;
    public static final int CHARGE = 200;
    public static final int SIZE = 10;

    public HellfireWand(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity user, ItemStack stack, int remain) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        BlockHitResult result = RayTraceUtil.rayTraceBlock((Level)level, (Player)player, (double)64.0);
        Vec3 center = result.m_82450_();
        int time = this.m_8105_(stack) - remain;
        if (level.m_5776_()) {
            return;
        }
        HellfireWand.renderRegionServer(user, center, time);
    }

    public static void renderRegionServer(LivingEntity user, Vec3 center, int time) {
        WandEffectToClient.Type.HELLFIRE_TICK.send(user, center, time);
    }

    public static void renderRegionClient(Level level, Vec3 center, int time) {
        double radius = (double)Math.min(200, time) * 1.0 * 10.0 / 200.0;
        for (int i = 0; i < 5; ++i) {
            float tpi = (float)Math.PI * 2;
            Vec3 v0 = new Vec3(0.0, radius, 0.0);
            v0 = v0.m_82496_(tpi / 4.0f).m_82524_(level.m_213780_().m_188501_() * tpi);
            level.m_7107_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_ + v0.f_82479_, center.f_82480_ + v0.f_82480_ + 0.5, center.f_82481_ + v0.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static void trigger(LivingEntity user, ServerLevel sl, Vec3 center, int time) {
        WandEffectToClient.Type.HELLFIRE_TRIGGER.send(user, center, time);
        float damage = (float)((Integer)LCConfig.COMMON.hellfireWandDamage.get()).intValue() * Math.min(3.0f, (float)time / 20.0f);
        double radius = (double)Math.min(200, time) * 1.0 * 10.0 / 200.0;
        for (Entity e : sl.m_45933_((Entity)user, AABB.m_165882_((Vec3)center.m_82520_(0.0, radius, 0.0), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0)))) {
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity x = (LivingEntity)e;
            if (e == user || e.m_7307_((Entity)user) || user.m_7307_(e)) continue;
            x.m_6469_(sl.m_269111_().m_269104_(null, (Entity)user), damage);
        }
    }

    public static void renderPentagonClient(Level level, Vec3 center, int time) {
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, SoundEvents.f_11874_, SoundSource.PLAYERS, 3.0f, 1.0f);
        double radius = (double)Math.min(200, time) * 1.0 * 10.0 / 200.0;
        double side = 1.644;
        double perimeter = Math.PI * 2;
        double total = side * 5.0 + perimeter;
        int size = time * 2;
        for (int i = 0; i < size; ++i) {
            Vec3 v0;
            double perc = (double)i * 1.0 / (double)size * total;
            if (perc < side * 5.0) {
                int start = (int)Math.floor(perc / side);
                Vec3 tip = new Vec3(0.0, radius, 0.0);
                tip = tip.m_82496_(1.5707964f).m_82524_((float)(2.5132741228718345 * (double)start));
                Vec3 next = tip.m_82524_(2.5132742f);
                v0 = tip.m_82549_(next.m_82546_(tip).m_82490_(perc / side - (double)start));
                level.m_7107_((ParticleOptions)ParticleTypes.f_123746_, center.f_82479_ + v0.f_82479_, center.f_82480_ + v0.f_82480_ + 0.5, center.f_82481_ + v0.f_82481_, 0.0, 1.0, 0.0);
                continue;
            }
            v0 = new Vec3(0.0, radius, 0.0);
            v0 = v0.m_82496_(1.5707964f).m_82524_((float)(perc - side * 5.0));
            level.m_7107_((ParticleOptions)ParticleTypes.f_123745_, center.f_82479_ + v0.f_82479_, center.f_82480_ + v0.f_82480_ + 0.5, center.f_82481_ + v0.f_82481_, 0.0, 1.0, 0.0);
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity user, int remain) {
        if (!(user instanceof Player)) {
            return;
        }
        Player player = (Player)user;
        stack.m_41622_(1, user, e -> e.m_21190_(e.m_7655_()));
        BlockHitResult result = RayTraceUtil.rayTraceBlock((Level)level, (Player)player, (double)64.0);
        Vec3 center = result.m_82450_();
        int time = this.m_8105_(stack) - remain;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            HellfireWand.trigger(user, sl, center, time);
        }
        player.m_36335_().m_41524_((Item)this, 10);
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)LangData.IDS.HELLFIRE_WAND.get(new Object[0]).m_130940_(ChatFormatting.GRAY));
    }
}

